using System;
using System.Collections.Generic;
using System.Text;
using Gemini.Core.WinForms;
using Gemini.Core.WinForms.Base;

namespace PI.ZB.N1200.ELearning.WinForms
{
    public class PlugIn : PI.FM.N000.Base.WinForms.Classes.BasePlugin
    {
        public PlugIn(Gemini.Core.WinForms.Interface.IEnvironment Environment,
            Gemini.Core.WinForms.Interface.IWindowsDescription WindowsDescription,
            string ProfileName)
            : base(Environment, WindowsDescription, ProfileName) { }


        public override long ClientID
        {
            get { return BL.Dictionary.Clients.PlugIn; }
        }

        protected override List<Gemini.Core.WinForms.Interface.IAccessDescription> DoGetMenuControls()
        {
            List<Gemini.Core.WinForms.Interface.IAccessDescription> _listAccessDescription = new List<Gemini.Core.WinForms.Interface.IAccessDescription>();

            _listAccessDescription.Add(new AccessDescription(BL.Dictionary.Objects.UI.Config));
            _listAccessDescription.Add(new AccessDescription(BL.Dictionary.Objects.UI.SchoolYear));
            _listAccessDescription.Add(new AccessDescription(BL.Dictionary.Objects.UI.ExerciseAvatar));
            _listAccessDescription.Add(new AccessDescription(BL.Dictionary.Objects.UI.CompetenceList));
            _listAccessDescription.Add(new AccessDescription(BL.Dictionary.Objects.UI.CompetencePartList));
            _listAccessDescription.Add(new AccessDescription(BL.Dictionary.Objects.UI.AdvancedLevelList));
            _listAccessDescription.Add(new AccessDescription(BL.Dictionary.Objects.UI.EvaluationSheetList));
            _listAccessDescription.Add(new AccessDescription(BL.Dictionary.Objects.UI.SchoolList));
            _listAccessDescription.Add(new AccessDescription(BL.Dictionary.Objects.UI.InstructorList));
            _listAccessDescription.Add(new AccessDescription(BL.Dictionary.Objects.UI.ClassList));
            _listAccessDescription.Add(new AccessDescription(BL.Dictionary.Objects.UI.StudentList));

            return _listAccessDescription;
        }

        #region Rejestracja komponentw
        protected override void DoInitialize(Gemini.Core.WinForms.Interface.IPlugInHandler Host)
        {
            Register(BL.Dictionary.Objects.UI.Config, typeof(WinForms.Config.UCConfigEdit));
            Register(BL.Dictionary.Objects.UI.ExerciseAvatar, typeof(WinForms.ExerciseAvatar.UCExerciseAvatarList));
            Register(BL.Dictionary.Objects.UI.SchoolYear, typeof(WinForms.SchoolYear.UCSchoolYearList));

            Register(BL.Dictionary.Objects.UI.CompetenceList, typeof(WinForms.Competence.UCCompetenceList));
            Register(BL.Dictionary.Objects.UI.CompetenceEdit, typeof(WinForms.Competence.UCCompetenceEdit));

            Register(BL.Dictionary.Objects.UI.CompetencePartList, typeof(WinForms.CompetencePart.UCCompetencePartList));
            Register(BL.Dictionary.Objects.UI.CompetencePartEdit, typeof(WinForms.CompetencePart.UCCompetencePartEdit));

            Register(BL.Dictionary.Objects.UI.AdvancedLevelList, typeof(WinForms.AdvancedLevel.UCAdvancedLevelList));
            Register(BL.Dictionary.Objects.UI.EvaluationSheetList, typeof(WinForms.EvaluationSheet.UCEvaluationSheetList));
            Register(BL.Dictionary.Objects.UI.SchoolList, typeof(WinForms.School.UCSchoolList));
            Register(BL.Dictionary.Objects.UI.InstructorList, typeof(WinForms.Instructor.UCInstructorList));
            Register(BL.Dictionary.Objects.UI.ClassList, typeof(WinForms.Class.UCClassList));
            Register(BL.Dictionary.Objects.UI.StudentList, typeof(WinForms.Student.UCStudentList));
        }
        #endregion
    }
}
